using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL.VAL.RPC
{	
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stas Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>2/27/2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///		This class is used by the VistALink Windows Service TCP/IP Listener 
	///		to collect and return VBECS data to various VistA packages.
	///</summary>

	#endregion

	public class VbecsPatientData : MarshalByRefObject
	{
		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/27/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6757"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>New instance of the class.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6758"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Default constructor.
		/// </summary>
		public VbecsPatientData() {}

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5999"> 
		///		<ExpectedInput>Valid VistaPatientId of a Patient in the Patient table.</ExpectedInput>
		///		<ExpectedOutput>xml string with Patient element containing dfn, firstName,
		///		lastName, dob, ssn, abo, and rh attributes.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6000"> 
		///		<ExpectedInput>null vistaPatientId</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method collects and returns patient demographic data including the ABO Group and Rh Type,
		/// if available, from VBECS.
		/// </summary>
		/// <param name="vistaPatientId">VistA patient identifier (DFN)</param>
		/// <returns>xml string containing Patient element with patient related attributes.</returns>
		public string GetPatientAboRh(string vistaPatientId)
		{
			if( (vistaPatientId == string.Empty ) || (vistaPatientId == null ) )
				throw( new ArgumentNullException( "vistaPatientId" ) );

			return RpcDataReader.GetXmlData( STOREDPROC.VistaGetXmlPatientAboRh.StoredProcName, GetVistaPatientIdSqlParameter(vistaPatientId));
		}

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6129"> 
		///		<ExpectedInput>Valid VistaPatientId of a Patient in the Patient table.</ExpectedInput>
		///		<ExpectedOutput>xml string containing TransfusionReaction element with type,
		///		date, unitId, productTypeName and productTypePrintName attributes.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6130"> 
		///		<ExpectedInput>null vistaPatientId parameter</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method returns and xml string containing transfusion reaction
		/// history for a specified patient.
		/// </summary>
		/// <param name="vistaPatientId">VistA patient identifier (DFN)</param>
		/// <returns>xml string</returns>
		public string GetTransfusionReactionHistory(string vistaPatientId)
		{
			if( (vistaPatientId == string.Empty ) || (vistaPatientId == null ) )
				throw( new ArgumentNullException( "vistaPatientId" ) );

			return RpcDataReader.GetXmlData( STOREDPROC.VistaGetXmlTransfusionReactionHistory.StoredProcName, GetVistaPatientIdSqlParameter(vistaPatientId));
		}

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6131"> 
		///		<ExpectedInput>Valid VistaPatientId of a Patient in the Patient table.</ExpectedInput>
		///		<ExpectedOutput>xml string containing Antibody element and name attribute.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6132"> 
		///		<ExpectedInput>null vistaPatientId parameter</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method collects and returns all antibodies that have been identified for
		/// a specified patient.
		/// </summary>
		/// <param name="vistaPatientId">VistA patient id (DFN)</param>
		/// <returns>xml string containing antibodies identified for a patient.</returns>
		public string GetAntibodies(string vistaPatientId)
		{
			if( (vistaPatientId == string.Empty ) || (vistaPatientId == null ) )
				throw( new ArgumentNullException( "vistaPatientId" ) );

			return RpcDataReader.GetXmlData( STOREDPROC.VistaGetXmlAntibodiesIdentified.StoredProcName, GetVistaPatientIdSqlParameter(vistaPatientId));
		}

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6133"> 
		///		<ExpectedInput>Valid VistaPatientId of a Patient in the Patient table.</ExpectedInput>
		///		<ExpectedOutput>xml string containing Unit element with status of "A" for autologous, id, product, abo,
		///		rh, divisionCode, location, and expDate attributes.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6134"> 
		///		<ExpectedInput>null vistaPatientId parameter</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6507"> 
		///		<ExpectedInput>Valid VistaPatientId of a Patient in the Patient table.</ExpectedInput>
		///		<ExpectedOutput>xml string containing Unit element with status of "S" for assigned, id, product, abo,
		///		rh, divisionCode, location, and expDate attributes.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6508"> 
		///		<ExpectedInput>Valid VistaPatientId of a Patient in the Patient table.</ExpectedInput>
		///		<ExpectedOutput>xml string containing Unit element with status of "D" for directed, id, product, abo,
		///		rh, divisionCode, location, and expDate attributes.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6509"> 
		///		<ExpectedInput>Valid VistaPatientId of a Patient in the Patient table.</ExpectedInput>
		///		<ExpectedOutput>xml string containing Unit element with status of "C" for crossmatched, id, product, abo,
		///		rh, divisionCode, location, and expDate attributes.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="8099"> 
		///		<ExpectedInput>Valid VistaPatientId of a Patient in the Patient table.</ExpectedInput>
		///		<ExpectedOutput>xml string containing Unit element with status of "I" for issued, id, product, abo,
		///		rh, divisionCode, location, and expDate attributes.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method collects and returns units that are available in VBECS
		/// for a patient within a specified date range.
		/// Implements BR_40.14
		/// </summary>
		/// <param name="vistaPatientId">VistA patient id (DFN)</param>
		/// <returns>xml string containing units available for a patient.</returns>
		public string GetAvailableUnits(string vistaPatientId )
		{
			if( (vistaPatientId == string.Empty ) || (vistaPatientId == null ) )
				throw( new ArgumentNullException( "vistaPatientId" ) );

			return RpcDataReader.GetXmlData( STOREDPROC.VistaGetXmlAvailableUnits.StoredProcName, GetVistaPatientIdSqlParameter(vistaPatientId ));
		}

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6135"> 
		///		<ExpectedInput>Valid VistaPatientId of a Patient in the Patient table.</ExpectedInput>
		///		<ExpectedOutput>xml string containing Transfusion element with date, unitsPooled,
		///		componentName and abbreviation attributes.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6136"> 
		///		<ExpectedInput>null vistaPatientId parameter</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method collects and returns a patient's transfusion history for a specified date range.
		/// </summary>
		/// <param name="vistaPatientId">VistA patient id (DFN)</param>
		/// <returns>xml string containing patient transfusions.</returns>
		public string GetTransfusionHistory(string vistaPatientId )
		{
			if( (vistaPatientId == string.Empty ) || (vistaPatientId == null ) )
				throw( new ArgumentNullException( "vistaPatientId" ) );

			return RpcDataReader.GetXmlData( STOREDPROC.VistaGetXmlTransfusionHistory.StoredProcName, GetVistaPatientIdSqlParameter(vistaPatientId ));
		}

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6137"> 
		///		<ExpectedInput>Valid VistaPatientId of a patient in the Patient table with specimen
		///		tests completed.</ExpectedInput>
		///		<ExpectedOutput>xml string containing the SpecimenTest element with printTestName, orderableTestName,
		///		result, testDate, cprsOrderId, divisionCode, enteringTechId and requestorId attributes.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6138"> 
		///		<ExpectedInput>null vistaPatientId parameter</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6139"> 
		///		<ExpectedInput>Valid VistaPatientId of a patient in the Patient table with component
		///		requests ordered.</ExpectedInput>
		///		<ExpectedOutput>xml string containing ComponentRequest element with dateRequested, dateWanted,
		///		cprsOrderId, componentClassName, componentClassShortName, requestorId, and enteredById
		///		attributes.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6140"> 
		///		<ExpectedInput>Valid VistaPatientId of a patient in the Patient table with Units available.</ExpectedInput>
		///		<ExpectedOutput>xml string containing Unit element with status of "S" for assigned, id, product, abo, rh, division,
		///		location and expDate attributes.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method collect VBECS patient data used for CPRS reports.
		/// Implements BR_40.14
		/// </summary>
		/// <param name="vistaPatientId">VistA patient id (DFN)</param>
		/// <returns>xml string containing VBECS patient report data</returns>
		public string GetPatientReportData(string vistaPatientId)
		{
			if( (vistaPatientId == string.Empty ) || (vistaPatientId == null ) )
				throw( new ArgumentNullException( "vistaPatientId" ) );

			return RpcDataReader.GetXmlData( STOREDPROC.VistaGetXmlPatientReportData.StoredProcName, GetVistaPatientIdSqlParameter(vistaPatientId));
		}

		/// <summary>
		/// Static method to create a common SqlParameter array containing a Vista patient id.
		/// </summary>
		/// <param name="vistaPatientId">VistA patient id</param>
		/// <returns>SqlParameter array</returns>
		private static SqlParameter[] GetVistaPatientIdSqlParameter(string vistaPatientId)
		{
			if( (vistaPatientId == string.Empty ) || (vistaPatientId == null ) )
				throw( new ArgumentNullException( "vistaPatientId" ) );

			SqlParameter[] _prms =
			{
				// CR 2431 changed vistaPatientId to bigint.
				new SqlParameter(STOREDPROC.VistaGetXmlPatientAboRh.VistaPatientId ,SqlDbType.BigInt)
			};
			_prms[0].Value = vistaPatientId;

			return _prms;
		}
	}
}
